unit main;

{$mode objfpc}{$H+}

interface

uses
	Classes,
	SysUtils,
	odbcconn,
	sqldb,
	FileUtil,
	Forms,
	Controls,
	Graphics,
	Dialogs,
	LConvEncoding,
	ExtCtrls;

type

	{ TfrmMain }

	TfrmMain = class(TForm)
		imgMain: TImage;
		odbcConnection: TODBCConnection;
		sqlQuery: TSQLQuery;
		sqlTransaction: TSQLTransaction;
		tmrMain: TTimer;
		procedure FormCreate(Sender: TObject);
		procedure tmrMainTimer(Sender: TObject);
	private
		{ private declarations }
	public
		{ public declarations }
	end;

var
	frmMain: TfrmMain;

implementation

{$R *.lfm}

{ TfrmMain }

const
  UNIX_LF = #10;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
	// initialize database components
	odbcConnection.DatabaseName := 'amadeus';
	odbcConnection.Transaction := sqlTransaction;
	sqlTransaction.Database := odbcConnection;
	sqlQuery.Database := odbcConnection;
	sqlQuery.Transaction := sqlTransaction;
	sqlQuery.UsePrimaryKeyAsKey := False;
end;

procedure TfrmMain.tmrMainTimer(Sender: TObject);
var
	buf: string;
	str: TFileStream;
  short: Boolean;
  name1: string;
begin
  tmrMain.Enabled := False;
  short := False;
  if Application.ParamCount = 1 then
  begin
		if Application.Params[1] = '/short' then
    begin
			short := True;
    end else begin
      ShowMessage('Invalid Parameter!');
    end;
	end;
	try
		tmrMain.Enabled := False;
		odbcConnection.Open;
		if odbcConnection.Connected then
		begin
			// export projects
			str := TFileStream.Create('project.txt', fmCreate);
			sqlQuery.SQL.Text :=
				'SELECT Objekt.idGUID, Objekt.TCProjectNo, ' +
				'Adressen.Name1, Adressen.Name2, Adressen.Name3, ' + 'Objekt.abgeschlossen ' +
				'FROM Objekt INNER JOIN (Adressen ' +
				'INNER JOIN (Kunden INNER JOIN Kaufvertr'#228'ge ON ' +
				'Kunden.kundennr = Kaufvertr'#228'ge.KUNDENNR) ON ' +
				'Adressen.adressnr = Kunden.adressnr) ON ' +
				'Objekt.ObjektNr = Kaufvertr'#228'ge.ObjektNr;';
			sqlQuery.Open;
			while not sqlQuery.EOF do
			begin
        if short then
        begin
          name1 := '';
        end else begin
        	name1 := sqlQuery.FieldByName('Name1').AsString;
        end;
				buf := ConvertEncoding(
					sqlQuery.FieldByName('idGUID').AsString + #9 +
					sqlQuery.FieldByName('TCProjectNo').AsString + #9 +
          Trim(
						name1 + ' ' +
	          sqlQuery.FieldByName('Name2').AsString + ' ' +
	          sqlQuery.FieldByName('Name3').AsString) + #9 +
	          sqlQuery.FieldByName('abgeschlossen').AsString + UNIX_LF,
	          EncodingAnsi, EncodingUTF8);
				str.Write(buf[1], Length(buf));
				sqlQuery.Next;
			end;
			sqlQuery.Close;
			str.Free;

			// export persons
			str := TFileStream.Create('person.txt', fmCreate);
			sqlQuery.SQL.Text :=
				'SELECT Lief.idGUID, Name1, Name2, Name3, Adressen.email ' +
				'FROM Adressen INNER JOIN Lief ON Adressen.adressnr = Lief.adressnr;';
			sqlQuery.Open;
			while not sqlQuery.EOF do
			begin
        if short then
        begin
          name1 := '';
        end else begin
        	name1 := sqlQuery.FieldByName('Name1').AsString;
        end;
				buf := ConvertEncoding(
					sqlQuery.FieldByName('idGUID').AsString + #9 +
					Trim(
         	name1 + ' ' +
          sqlQuery.FieldByName('Name2').AsString + ' ' +
          sqlQuery.FieldByName('Name3').AsString) + #9 +
          sqlQuery.FieldByName('email').AsString + UNIX_LF,
          EncodingAnsi, EncodingUTF8);
				str.Write(buf[1], Length(buf));
				sqlQuery.Next;
			end;
			sqlQuery.Close;
			str.Free;

			// export placings
			str := TFileStream.Create('placing.txt', fmCreate);
			sqlQuery.SQL.Text :=
				'SELECT Objekt.idGUID as project_unid, Lief.idGUID as person_unid '
				+ 'FROM Objekt INNER JOIN (Kosten INNER JOIN Lief ' +
				'ON Kosten.liefnr = Lief.liefnr) ON Objekt.ObjektNr = Kosten.objektnr;';
			sqlQuery.Open;
			while not sqlQuery.EOF do
			begin
				buf := ConvertEncoding(
	        sqlQuery.FieldByName('project_unid').AsString +
					#9 + sqlQuery.FieldByName('person_unid').AsString + UNIX_LF,
          EncodingAnsi, EncodingUTF8);
				str.Write(buf[1], Length(buf));
        sqlQuery.Next;
			end;
			sqlQuery.Close;
			str.Free;

			// finish program
			odbcConnection.Close;
		end;
	except
		on E: Exception do
		begin
			// show exception message, if something gets wrong
			ShowMessage(E.Message);
		end;
	end;
	Close;


end;

end.
